/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/InstanceofExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IInstanceofExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class InstanceofExpression implements IInstanceofExpression {

	private org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression ioe;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression lOperand;
	private IType type;
	
	public InstanceofExpression(
		org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression ioe,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.ioe = ioe;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.INSTANCEOF_EXPRESSION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IInstanceofExpression#getLeftOperand()
	 */
	public IExpression getLeftOperand() {
		if ( lOperand == null ) {
			lOperand = Wrapper.wrapExpression(ioe.expression, scope, source);
		}
		return lOperand;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IInstanceofExpression#getRightOperand()
	 */
	public IType getRightOperand() {
		if (type == null ) {
			org.eclipse.jdt.internal.compiler.ast.TypeReference temp = ioe.type;
					if (temp instanceof ArrayTypeReference) {
						type = new ArrayTypeFromTypeReference((ArrayTypeReference) temp);
					} else {
						type = new SimpleTypeFromTypeReference(temp);	
					}
		}
	    return type;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(ioe.resolvedType);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ioe.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getLeftOperand().traverse(visitor);
			getRightOperand().traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
