/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/InitializerFromInitializer.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;

public class InitializerFromInitializer extends Initializer {

	private org.eclipse.jdt.internal.compiler.ast.Initializer init;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IBlock body;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public InitializerFromInitializer(
		org.eclipse.jdt.internal.compiler.ast.Initializer init,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.init = init;
		this.scope = scope;
		this.source = source;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IInitializer#getModifiers()
	 */
	public int getModifiers() {
		return init.modifiers;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IInitializer#getBody()
	 */
	public IBlock getBody() {
		if (body == null) {
			body = new Block(init.block, source);
		}
		return body;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return init.sourceStart;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(init.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(init.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
