/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/InfixExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class InfixExpression implements IInfixExpression {

	private org.eclipse.jdt.internal.compiler.ast.BinaryExpression be;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression lExpr;
	private IExpression rExpr;	
	
	public InfixExpression(
		org.eclipse.jdt.internal.compiler.ast.BinaryExpression be,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.be = be;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.INFIX_EXPRESSION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression#getOperator()
	 */
	public String getOperator() {
		return be.operatorToString();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression#getLeftOperand()
	 */
	public IExpression getLeftOperand() {
		if ( lExpr == null ) {
			lExpr = Wrapper.wrapExpression(be.left, scope, source);
		}
		return lExpr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression#getRightOperand()
	 */
	public IExpression getRightOperand() {
		if ( rExpr == null ) {
			rExpr = Wrapper.wrapExpression(be.right, scope, source);
		}
		return rExpr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(be.resolvedType);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return be.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getLeftOperand().traverse(visitor);
			getRightOperand().traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
