/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ImportDeclarationWithImportBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;

/**
 * @author d034036
 */
public class ImportDeclarationWithImportBinding extends ImportDeclaration {

	private org.eclipse.jdt.internal.compiler.lookup.ImportBinding ib;

	public ImportDeclarationWithImportBinding(
		org.eclipse.jdt.internal.compiler.ast.ImportReference ir,
		org.eclipse.jdt.internal.compiler.lookup.ImportBinding ib) {
		this.ir = ir;
		this.ib = ib;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration#resolveBinding()
	 */
	public IBinding resolveBinding() {
		return new PackageBindingFromImportBinding(ib);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration#isOnDemand()
	 */
	public boolean isOnDemand() {
		return true;
	}

}
