/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ImportDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

/**
 * @author d034036
 */
abstract public class ImportDeclaration implements IImportDeclaration {

	protected org.eclipse.jdt.internal.compiler.ast.ImportReference ir;

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration#getName()
	 */
	public String[] getName() {
		char[][] tokens = ir.tokens;
		String[] out = new String[tokens.length];
		for (int i = 0; i < tokens.length; i++) {
			out[i] = new String(tokens[i]);
		}
		return out;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.IMPORT_DECLARATION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ir.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		visitor.visit(this);
		visitor.endVisit(this);
	}

}
