/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/IfStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class IfStatement implements IIfStatement {

	private org.eclipse.jdt.internal.compiler.ast.IfStatement is;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression condition;
	private IStatement thenStmt;
	private IStatement elseStmt;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public IfStatement(
		org.eclipse.jdt.internal.compiler.ast.IfStatement is,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.is = is;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.IF_STATEMENT;
	}

	/**
	* @see com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement#getExpression()
	*/
	public IExpression getExpression() {
		if (condition == null) {
			condition = Wrapper.wrapExpression(is.condition, scope, source);
		}
		return condition;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement#getThenStatement()
	 */
	public IStatement getThenStatement() {
		if (thenStmt == null) {
			thenStmt = Wrapper.wrapStatement(is.thenStatement, scope, source);
		}
		return thenStmt;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement#getElseStatement()
	 */
	public IStatement getElseStatement() {
		if (elseStmt == null) {
			elseStmt = Wrapper.wrapStatement(is.elseStatement, scope, source);
		}
		return elseStmt;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return is.sourceStart;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(is.sourceEnd);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(is.sourceEnd);
      commentParsed = true;
		}
		return endOfLineComment;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getExpression().traverse(visitor);
			getThenStatement().traverse(visitor);
			IStatement elseStatement = getElseStatement();
			if (elseStatement != null)
				elseStatement.traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
