/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ForStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ForStatement implements IForStatement {

	private org.eclipse.jdt.internal.compiler.ast.ForStatement fs;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IStatement[] initializers;
	private IExpression expression;
	private IExpression[] updaters;
	private IStatement body;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;
	
	public ForStatement(
		org.eclipse.jdt.internal.compiler.ast.ForStatement fs,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.fs = fs;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.FOR_STATEMENT;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IForStatement#initializers()
	 */
	public IStatement[] getInitializers() {
		if (initializers == null) {
			org.eclipse.jdt.internal.compiler.ast.Statement[] statements =
				fs.initializations;
			if (statements == null || statements.length == 0) {
				initializers = new IStatement[0];
			} else {
				initializers = new IStatement[statements.length];
				if (statements[0] instanceof LocalDeclaration) {
					for (int i = 0; i < statements.length; i++) {
						initializers[i] =
							new VariableDeclarationStatement(
								(LocalDeclaration) statements[i],
								scope,
								source);
					}
				} else {
					for (int i = 0; i < statements.length; i++) {
						initializers[i] =
							Wrapper.wrapStatement(statements[i], scope, source);
					}
				}
			}
		}
		return initializers;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IForStatement#getExpression()
	 */
	public IExpression getExpression() {
		if (expression == null && fs.condition != null) {
			expression = Wrapper.wrapExpression(fs.condition, scope, source);
		}
		return expression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IForStatement#updaters()
	 */
	public IExpression[] getUpdaters() {
		if (updaters == null) {
			org.eclipse.jdt.internal.compiler.ast.Statement[] statements =
				fs.increments;
			if (statements == null) {
				updaters = new IExpression[0];
			} else {
				updaters = new IExpression[statements.length];
				for (int i = 0; i < statements.length; i++) {
					if (statements[i]
						instanceof org.eclipse.jdt.internal.compiler.ast.Expression) {
						updaters[i] =
							Wrapper.wrapExpression(
								(org
									.eclipse
									.jdt
									.internal
									.compiler
									.ast
									.Expression) statements[i],
								scope,
								source);
					} else
						throw new IllegalArgumentException(
							"wrong updater class: "
								+ statements[i].getClass().getName());
				}
			}

		}
		return updaters;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IForStatement#getBody()
	 */
	public IStatement getBody() {
		if ( body == null ) {
			if (fs.action == null) {
				body = new EmptyStatement(fs.sourceEnd, source);
			} else {
				body = Wrapper.wrapStatement(fs.action, scope, source);			
			}
		}
		return body;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return fs.sourceStart;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(fs.sourceEnd);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(fs.sourceEnd);
      commentParsed = true;
		}
		return endOfLineComment;
	}
	
	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {

		if (visitor.visit(this)) {
			IStatement[] initializers = getInitializers();
			for (int i = 0; i < initializers.length; i++) {
				initializers[i].traverse(visitor);
			}

			IExpression condition = getExpression();
			if (condition != null)
				condition.traverse(visitor);

			IExpression[] updaters = getUpdaters();
			for (int i = 0; i < updaters.length; i++) {
				updaters[i].traverse(visitor);
			}

			getBody().traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
