/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/FieldDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;

public class FieldDeclaration implements IFieldDeclaration {

	private org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fd;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IType type;
	private IExpression initializer;
	private IJavadoc javadoc;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed;

	public FieldDeclaration(
		org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fd,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.fd = fd;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.FIELD_DECLARATION;
	}

	public int getStartPosition() {
		return fd.declarationSourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration#getModifiers()
	 */
	public int getModifiers() {
		return fd.modifiers;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration#getType()
	 */
	public IType getType() {
		if (type == null) {
			org.eclipse.jdt.internal.compiler.ast.TypeReference tr = fd.type;
			if (tr instanceof ArrayTypeReference) {
				type = new ArrayTypeFromTypeReference((ArrayTypeReference) tr);
			} else if (tr instanceof ArrayQualifiedTypeReference) {
				type =
					new ArrayTypeFromTypeReference(
						(ArrayQualifiedTypeReference) tr);
			} else if (tr instanceof SingleTypeReference) {
				type =
					new SimpleTypeFromTypeReference((SingleTypeReference) tr);
			} else if (tr instanceof QualifiedTypeReference) {
				type = new SimpleTypeFromTypeReference((TypeReference) tr);
			} else {
				throw new IllegalArgumentException(
					"illegal type: " + tr.getClass().getName());
			}
		}
		return type;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#getName()
	 */
	public String getName() {
		return new String(fd.name);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#getInitializer()
	 */
	public IExpression getInitializer() {
		if (initializer == null && fd.initialization != null) {
			initializer =
				Wrapper.wrapExpression(fd.initialization, scope, source);
		}
		return initializer;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#resolveBinding()
	 */
	public IVariableBinding resolveBinding() {
		return new VariableBinding(fd.binding);
	}
	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBodyDeclaration#getJavadoc()
	 */
	public IJavadoc getJavadoc() {
		if (javadoc == null) {
			javadoc = source.getJavadoc(fd.declarationSourceStart);
		}
		return javadoc;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(fd.declarationEnd);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(fd.declarationEnd);
      commentParsed = true;
		}
		return endOfLineComment;
	}

	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getType().traverse(visitor);
			IExpression initializer = getInitializer();
			if (initializer != null) {
				initializer.traverse(visitor);
			}
		}
		visitor.endVisit(this);
	}

}
