/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/FieldAccessFromQualifiedNameReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;

public class FieldAccessFromQualifiedNameReference extends FieldAccess {

	private org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference qnr;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;
	private int index;

	/* cache */
	private IExpression expression;

	public FieldAccessFromQualifiedNameReference(
		org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference qnr,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source,
		int index) {
		this.qnr = qnr;
		this.scope = scope;
		this.source = source;
		this.index = index;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess#getExpression()
	 */
	public IExpression getExpression() {
		if (expression == null) {
			int tokenLength = qnr.tokens.length;
			int prefixLength =
				tokenLength
					- 1
					- ((qnr.otherBindings == null)
						? 0
						: qnr.otherBindings.length);
			if (index == prefixLength) { //static access: A.B.f
				if (index == 1) {
					expression = new SimpleNameFromQualifiedNameReference(qnr);
				} else {
					expression =
						new QualifiedNameFromQualifiedNameReference(
							qnr,
							index - 1,
							null);
				}
			} else if (index == prefixLength + 1) {
				// prefix.f.g we're looking at g -> expr = f
				if (prefixLength == 0) {
					expression = new SimpleNameFromQualifiedNameReference(qnr);
				} else {
					Binding exprBinding = qnr.binding;
					if (exprBinding instanceof FieldBinding) {
						expression =
							new FieldAccessFromQualifiedNameReference(
								qnr,
								scope,
								source,
								index - 1);
					}
					//			        return new QualifiedName(qnr);
				}
			} else {
				expression =
					new FieldAccessFromQualifiedNameReference(
						qnr,
						scope,
						source,
						index - 1);
			}
		}
		return expression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess#getName()
	 */
	public String getName() {
		return new String(qnr.tokens[index]);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		int tokenLength = qnr.tokens.length;
		int prefixLength =
			tokenLength
				- 1
				- ((qnr.otherBindings == null) ? 0 : qnr.otherBindings.length);
		if (index == prefixLength)
			return BindingFactory.getTypeBinding(
				((FieldBinding) qnr.binding).type);
		return BindingFactory.getTypeBinding(
			qnr.otherBindings[index - prefixLength - 1].type);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return qnr.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess#resolveBinding()
	 */
	public IVariableBinding resolveBinding() {

		int tokenLength = qnr.tokens.length;
		int prefixLength =
			tokenLength
				- 1
				- ((qnr.otherBindings == null) ? 0 : qnr.otherBindings.length);
		if (index == prefixLength) {
			return new VariableBinding((FieldBinding) qnr.binding);
		} else if (index > prefixLength) {
			return new VariableBinding(
				qnr.otherBindings[index - prefixLength - 1]);
		}
		//            return new TypeBinding(((FieldBinding)qnr.binding).declaringClass);
		return null;
	}

}
