/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/FieldAccessFromFieldReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

 
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;

public class FieldAccessFromFieldReference extends FieldAccess {

	private org.eclipse.jdt.internal.compiler.ast.FieldReference fr;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expression;

	public FieldAccessFromFieldReference(
		org.eclipse.jdt.internal.compiler.ast.FieldReference fr,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.fr = fr;
		this.scope = scope;
		this.source = source;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess#getExpression()
	 */
	public IExpression getExpression() {
		if ( expression == null && fr.receiver != null ) {
			expression = Wrapper.wrapExpression(fr.receiver, scope, source);
		}
		return expression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess#getName()
	 */
	public String getName() {
		return new String(fr.token);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		if (fr.binding == null)
			return null;
		return BindingFactory.getTypeBinding(fr.binding.type);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return fr.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess#resolveBinding()
	 */
	public IVariableBinding resolveBinding() {
		return new VariableBinding(fr.binding);
	}

}
