/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ExpressionStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ExpressionStatement implements IExpressionStatement {

	private org.eclipse.jdt.internal.compiler.ast.Expression expr;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expression;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public ExpressionStatement(
		org.eclipse.jdt.internal.compiler.ast.Expression expr,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.expr = expr;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.EXPRESSION_STATEMENT;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement#getExpression()
	 */
	public IExpression getExpression() {
		if (expression == null) {
			expression = Wrapper.wrapExpression(expr, scope, source);
		}
		return expression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return expr.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getExpression().traverse(visitor);
		}
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(expr.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(expr.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
