/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ContinueStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ContinueStatement implements IContinueStatement {

	private org.eclipse.jdt.internal.compiler.ast.Continue cs;
	private SourceContent source;

	/* cache */
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public ContinueStatement(
		org.eclipse.jdt.internal.compiler.ast.Continue cs,
		SourceContent source) {
		this.cs = cs;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.CONTINUE_STATEMENT;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement#getLabel()
	 */
	public String getLabel() {
		if (cs.label == null)
			return null;
		return new String(cs.label);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return cs.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		visitor.visit(this);
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(cs.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(cs.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
