/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ConstructorInvocation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;

public class ConstructorInvocation implements IConstructorInvocation {

	private ExplicitConstructorCall cc;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private List arguments;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public ConstructorInvocation(
		ExplicitConstructorCall cc,
		BlockScope scope,
		SourceContent source) {
		this.cc = cc;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.CONSTRUCTOR_INVOCATION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation#arguments()
	 */
	public List arguments() {
		if (arguments == null) {
			arguments = new Vector();
			org.eclipse.jdt.internal.compiler.ast.Expression[] argumentArray =
				cc.arguments;
			if (argumentArray != null) {
				for (int i = 0; i < argumentArray.length; i++)
					arguments.add(
						Wrapper.wrapExpression(
							argumentArray[i],
							scope,
							source));
			}
		}
		return arguments;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation#resolveConstructorBinding()
	 */
	public IMethodBinding resolveConstructorBinding() {
		org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding =
			cc.binding;
		if (binding == null)
			return null;
		return new MethodBinding(binding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return cc.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			List arguments = arguments();
			if (arguments != null) {
				Iterator iterator = arguments.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
		}
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(cc.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(cc.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
