/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ConditionalExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ConditionalExpression implements IConditionalExpression {

	private org.eclipse.jdt.internal.compiler.ast.ConditionalExpression ce;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expression;
	private IExpression thenExpression;
	private IExpression elseExpression;	
	
	public ConditionalExpression(
		org.eclipse.jdt.internal.compiler.ast.ConditionalExpression ce,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.ce = ce;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.CONDITIONAL_EXPRESSION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression#getExpression()
	 */
	public IExpression getExpression() {
		if ( expression == null ) {
			expression = Wrapper.wrapExpression(ce.condition, scope, source);
		}
		return expression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression#getThenExpression()
	 */
	public IExpression getThenExpression() {
		if ( thenExpression == null ) {
			thenExpression = Wrapper.wrapExpression(ce.valueIfTrue, scope, source);
		}
		return thenExpression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression#getElseExpression()
	 */
	public IExpression getElseExpression() {
		if ( elseExpression == null ) {
			elseExpression = Wrapper.wrapExpression(ce.valueIfFalse, scope, source);
		}
		return elseExpression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(ce.resolvedType);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ce.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getExpression().traverse(visitor);
			getThenExpression().traverse(visitor);
			getElseExpression().traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
