/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ClassInstanceCreation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;

import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IName;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ClassInstanceCreation implements IClassInstanceCreation {

	private AllocationExpression ae;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expression;
	private IName name;
	private List arguments;
	private IAnonymousClassDeclaration acd;

	public ClassInstanceCreation(
		AllocationExpression ae,
		BlockScope scope,
		SourceContent source) {
		this.ae = ae;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.CLASS_INSTANCE_CREATION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation#getExpression()
	 */
	public IExpression getExpression() {
		if (expression == null) {
			expression =
				Wrapper.wrapExpression(ae.enclosingInstance(), scope, source);
		}
		return expression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation#getName()
	 */
	public IName getName() {
		if (name == null) {
			org.eclipse.jdt.internal.compiler.ast.TypeReference tr = ae.type;
			if (tr.getTypeName().length > 1) {
				name = new QualifiedNameFromTypeReference(tr);
			} else {
				name = new SimpleNameFromTypeReference(tr);
			}
		}
		return name;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation#arguments()
	 */
	public List arguments() {
		if (arguments == null) {
			arguments = new Vector();
			org.eclipse.jdt.internal.compiler.ast.Expression[] argumentArray =
				ae.arguments;
			if (argumentArray != null) {
				for (int i = 0; i < argumentArray.length; i++) {
					arguments.add(
						Wrapper.wrapExpression(
							argumentArray[i],
							scope,
							source));
				}

			}
		}
		return arguments;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation#getAnonymousClassDeclaration()
	 */
	public IAnonymousClassDeclaration getAnonymousClassDeclaration() {
		if ( acd == null) {
			if (ae instanceof QualifiedAllocationExpression) {
				AnonymousLocalTypeDeclaration altd =
					((QualifiedAllocationExpression) ae).anonymousType;
				if (altd != null) {
					acd = new AnonymousClassDeclaration(altd, scope, source);
				}
			}			
		}
        return acd;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation#resolveConstructorBinding()
	 */
	public IMethodBinding resolveConstructorBinding() {
		org.eclipse.jdt.internal.compiler.lookup.MethodBinding mb = ae.binding;
		if (mb == null)
			return null;
		return new MethodBinding(mb);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding tb =
			ae.type.resolvedType;
		if (tb == null)
			return null;
		return ((MethodBinding) resolveConstructorBinding())
			.getDeclaringClass();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ae.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {

		if (visitor.visit(this)) {
			getName().traverse(visitor);
			IExpression expr = getExpression();
			if (expr != null)
				expr.traverse(visitor);
			List arguments = arguments();
			if (arguments != null) {
				Iterator iterator = arguments.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
			IAnonymousClassDeclaration ac = getAnonymousClassDeclaration();
			if (ac != null)
				ac.traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
