/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/CharacterLiteral.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;

import org.eclipse.jdt.internal.compiler.ast.CharLiteral;

import com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class CharacterLiteral implements ICharacterLiteral {

	private CharLiteral literal;

	public CharacterLiteral(CharLiteral literal) {
		this.literal = literal;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.CHARACTER_LITERAL;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral#charValue()
	 */
	public char charValue() {
		return literal.constant.charValue();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getPrimitiveTypeBinding(BaseTypeBinding.CharBinding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return literal.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		visitor.visit(this);
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral#getEscapedValue()
	 */
	public String getEscapedValue() {
		switch (charValue()) {
			case '\b' :
				return ("\\b"); //$NON-NLS-1$
			case '\t' :
				return ("\\t"); //$NON-NLS-1$
			case '\n' :
				return ("\\n"); //$NON-NLS-1$
			case '\f' :
				return ("\\f"); //$NON-NLS-1$
			case '\r' :
				return ("\\r"); //$NON-NLS-1$
			case '\"' :
				return ("\\\""); //$NON-NLS-1$
			case '\'' :
				return ("\\'"); //$NON-NLS-1$
			case '\\' : //take care not to display the escape as a potential real char
				return ("\\\\"); //$NON-NLS-1$
			default :
				return String.valueOf(charValue());
		}
	}

}
