/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/CatchClause.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class CatchClause implements ICatchClause {

	private Argument argument;
	private org.eclipse.jdt.internal.compiler.ast.Block block;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private IVariableDeclaration exception;
	private IBlock body;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public CatchClause(
		Argument argument,
		org.eclipse.jdt.internal.compiler.ast.Block block,
		BlockScope scope,
		SourceContent source) {

		this.argument = argument;
		this.block = block;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.CATCH_CLAUSE;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause#getException()
	 */
	public IVariableDeclaration getException() {
		if (exception == null) {
			exception = new SingleVariableDeclaration(argument, scope, source);
		}
		return exception;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause#getBody()
	 */
	public IBlock getBody() {
		if (body == null) {
			body = new Block(block, source);
		}
		return body;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return block.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getException().traverse(visitor);
			getBody().traverse(visitor);
		}
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(block.sourceEnd);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(block.sourceStart);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
