/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/CastExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;

import com.sap.tc.jtools.jlint.jom.interfaces.ICastExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class CastExpression implements ICastExpression {
	private org.eclipse.jdt.internal.compiler.ast.CastExpression ce;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private IType type;
	IExpression expression;

	public CastExpression(
		org.eclipse.jdt.internal.compiler.ast.CastExpression ce,
		BlockScope scope,
		SourceContent source) {
		this.ce = ce;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.CAST_EXPRESSION;
	}

	public int getStartPosition() {
		return ce.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ICastExpression#getType()
	 */
	public IType getType() {
		if (type == null) {
			org.eclipse.jdt.internal.compiler.ast.Expression temp = ce.type;
			if (temp instanceof SingleNameReference) {
				type =
					new SimpleTypeFromNameReference((SingleNameReference) temp);
			} else if (temp instanceof QualifiedNameReference) {
				type =
					new SimpleTypeFromNameReference(
						(QualifiedNameReference) temp);
			} else if (temp instanceof ArrayTypeReference) {
				type =
					new ArrayTypeFromTypeReference((ArrayTypeReference) temp);
			} else if (temp instanceof ArrayQualifiedTypeReference) {
				type =
					new ArrayTypeFromTypeReference(
						(ArrayQualifiedTypeReference) temp);
			} else if (temp instanceof QualifiedTypeReference) {
				type =
					new SimpleTypeFromTypeReference(
						(QualifiedTypeReference) temp);
			} else if (temp instanceof SingleTypeReference) {
				type =
					new SimpleTypeFromTypeReference((SingleTypeReference) temp);
			}
		}

		return type;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ICastExpression#getExpression()
	 */
	public IExpression getExpression() {
		if ( expression == null ) {
			expression = Wrapper.wrapExpression(ce.expression, scope, source);
		}
		return expression;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return getType().resolveBinding();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getType().traverse(visitor);
			getExpression().traverse(visitor);
		}
		visitor.endVisit(this);
	}
}
