/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/BooleanLiteral.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;

import com.sap.tc.jtools.jlint.jom.interfaces.IBooleanLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class BooleanLiteral implements IBooleanLiteral {
	static final ITypeBinding binding = 
	    BindingFactory.getPrimitiveTypeBinding(org.eclipse.jdt.internal.compiler.ast.MagicLiteral.BooleanBinding);
    
    public org.eclipse.jdt.internal.compiler.ast.MagicLiteral literal;
     
    public BooleanLiteral(org.eclipse.jdt.internal.compiler.ast.FalseLiteral literal) {
		this.literal = literal;
	}
	
    public BooleanLiteral(org.eclipse.jdt.internal.compiler.ast.TrueLiteral literal) {
		this.literal = literal;
	}	

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
   */
  public int getNodeType() {
    return Traversable.BOOLEAN_LITERAL;
  }


	
	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBooleanLiteral#booleanValue()
	 */
	public boolean booleanValue() {
		return literal instanceof TrueLiteral;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
        return binding;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
    public int getStartPosition() {
    	return literal.sourceStart;
    }

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
    public void traverse(IVisitor visitor) {
	    visitor.visit(this);
	    visitor.endVisit(this);
    }

}
