/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/Block.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class Block implements IBlock {

	private org.eclipse.jdt.internal.compiler.ast.Statement[] statements;
	private int startPosition;
	private int endPosition;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private List statementList;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public Block(
		org.eclipse.jdt.internal.compiler.ast.Statement[] statements,
		int startPosition,
		int endPosition,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		if (statements == null)
			this.statements =
				new org.eclipse.jdt.internal.compiler.ast.Statement[0];
		else
			this.statements = statements;

		this.startPosition = startPosition;
		this.endPosition = endPosition;
		this.scope = scope;
		this.source = source;
	}

	public Block(
		org.eclipse.jdt.internal.compiler.ast.Block block,
		SourceContent source) {
		this.statements = block.statements;
		if (statements == null)
			this.statements =
				new org.eclipse.jdt.internal.compiler.ast.Statement[0];
		this.startPosition = block.sourceStart;
		this.endPosition = block.sourceEnd;
		this.scope = block.scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.BLOCK;
	}

	public int getStartPosition() {
		return startPosition;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBlock#statements()
	 */
	public List statements() {
		if (statementList == null) {
			statementList = new ArrayList(statements.length);
			for (int i = 0; i < statements.length; i++) {
				IStatement stmt =
					Wrapper.wrapStatement(statements[i], scope, source);
				statementList.add(stmt);
			}
		}
		return statementList;
	}

	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
      for (Iterator iter = statements().iterator(); iter.hasNext();) {
					 ((Traversable) iter.next()).traverse(visitor);
			}
		}
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(endPosition);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(startPosition);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
