/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/BindingFactory.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPrimitiveTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

/**
 * @author d034036
 */
public class BindingFactory {

  private static Map cache = new HashMap();

  private BindingFactory() {
  }

  public static ITypeBinding getTypeBinding(TypeBinding binding) {
    if (binding == null)
      return null;
    ITypeBinding bnd = (ITypeBinding) cache.get(binding);
    if (bnd != null)
      return bnd;
    if (binding instanceof BaseTypeBinding) {
      bnd = new PrimitiveTypeBinding((BaseTypeBinding) binding);
    } else if (binding instanceof ArrayBinding) {
      bnd = new ArrayTypeBinding((ArrayBinding) binding);
    } else if (binding instanceof ReferenceBinding) {
      bnd = new ReferenceTypeBinding((ReferenceBinding) binding);
    } else {
      throw new IllegalArgumentException(
        "unknown internal binding class: " + binding.getClass().getName());
    }
    cache.put(binding, bnd);
    return bnd;
  }

  public static IReferenceTypeBinding getReferenceTypeBinding(ReferenceBinding binding) {
    if (binding == null)
      return null;
    IReferenceTypeBinding bnd = (IReferenceTypeBinding) cache.get(binding);
    if (bnd != null)
      return bnd;
    bnd = new ReferenceTypeBinding(binding);
    cache.put(binding, bnd);
    return bnd;
  }

  public static IPrimitiveTypeBinding getPrimitiveTypeBinding(BaseTypeBinding binding) {
    if (binding == null)
      return null;
    IPrimitiveTypeBinding bnd = (IPrimitiveTypeBinding) cache.get(binding);
    if (bnd != null)
      return bnd;
    bnd = new PrimitiveTypeBinding(binding);
    cache.put(binding, bnd);
    return bnd;
  }

  public static IArrayTypeBinding getArrayTypeBinding(ArrayBinding binding) {
    if (binding == null)
      return null;
    IArrayTypeBinding bnd = (IArrayTypeBinding) cache.get(binding);
    if (bnd != null)
      return bnd;
    bnd = new ArrayTypeBinding(binding);
    cache.put(binding, bnd);
    return bnd;
  }

  public static IPackageBinding getPackageBinding(PackageBinding binding) {
    if (binding == null)
      return null;
    IPackageBinding bnd = (IPackageBinding) cache.get(binding);
    if (bnd != null)
      return bnd;
    bnd = new PackageBindingFromPackageBinding(binding);
    cache.put(binding, bnd);
    return bnd;
  }

  public static void clearCache() {
    cache.clear();
  }
}
