/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/Assignment.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;

public class Assignment implements IAssignment {

	private org.eclipse.jdt.internal.compiler.ast.Assignment as;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression lhs;
	private IExpression rhs;
		
	public Assignment(
		org.eclipse.jdt.internal.compiler.ast.Assignment as,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.as = as;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.ASSIGNMENT;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IAssignment#getOperator()
	 */
	public String getOperator() {
		if (as instanceof CompoundAssignment)
			return ((CompoundAssignment) as).operatorToString();
		return IAssignment.ASSIGN;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IAssignment#getLeftHandSide()
	 */
	public IExpression getLeftHandSide() {
		if ( lhs == null ) {
			lhs = Wrapper.wrapExpression(as.lhs, scope, source);
		}
		return lhs;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IAssignment#getRightHandSide()
	 */
	public IExpression getRightHandSide() {
		if ( rhs == null ) {
			rhs = Wrapper.wrapExpression(as.expression, scope, source);
		}
		return rhs;		
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return Wrapper
			.wrapExpression(as.lhs, scope, source)
			.resolveTypeBinding();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return as.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getLeftHandSide().traverse(visitor);
			getRightHandSide().traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
