/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ArrayTypeFromTypeReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
							
public class ArrayTypeFromTypeReference extends ArrayType {

	private org.eclipse.jdt.internal.compiler.ast.TypeReference at;
	private int dim;
	private int extraDims;

	/* cache - no attributes to cache */
	
	
	public ArrayTypeFromTypeReference(ArrayTypeReference at) {
		this( at,0);
    }

	public ArrayTypeFromTypeReference(ArrayQualifiedTypeReference at) {
		this( at,0);
    }
    		
	public ArrayTypeFromTypeReference(
		org.eclipse.jdt.internal.compiler.ast.TypeReference at, int extraDims) {
		this.at = at;

		if (at instanceof org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference) {
			this.dim = ((ArrayTypeReference) at).dimensions;
		} else if (at instanceof org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference) {
			this.dim =((ArrayQualifiedTypeReference) at).dimensions();
		} 
		this.extraDims = extraDims;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IArrayType#getComponentType()
	 */
	public ITypeBinding getComponentType() {
		if ( extraDims == 1 ) {
			return BindingFactory.getTypeBinding(at.resolvedType);	
		}
		if ( extraDims > 1 ) {
		    return new ArrayTypeBinding(at.resolvedType, extraDims-1);	
		}
 
		// at now *must* be an array
		org.eclipse.jdt.internal.compiler.lookup.ArrayBinding binding =
			(org.eclipse.jdt.internal.compiler.lookup.ArrayBinding) at.resolvedType;
		if (binding == null)
			return null;
		
		if ( dim == 1 ) {
			return BindingFactory.getTypeBinding(binding.leafComponentType);	
		} else {
			return new ArrayTypeBinding(binding.leafComponentType, dim-1);	
		}		
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IArrayType#getElementType()
	 */
	public ITypeBinding getElementType() {
		if ( at.dimensions() == 0 ) {
			return BindingFactory.getTypeBinding(at.resolvedType);
		}
		org.eclipse.jdt.internal.compiler.lookup.ArrayBinding binding =
			(org.eclipse.jdt.internal.compiler.lookup.ArrayBinding) at.resolvedType;
		if (binding == null)
			return null;
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding tb =
			binding.leafComponentType();
		return BindingFactory.getTypeBinding(tb); 
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IArrayType#getDimensions()
	 */
	public int getDimensions() {
		return dim + extraDims;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IType#resolveBinding()
	 */
	public ITypeBinding resolveBinding() {
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding tb = at.resolvedType;
		return BindingFactory.getTypeBinding(tb);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return at.sourceStart;
	}

}
