/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ArrayTypeBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class ArrayTypeBinding implements IArrayTypeBinding {

	private static final String ARRAY_INDICATOR = "[]";
	
	org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding;
	int extraDims;

	public ArrayTypeBinding(
		org.eclipse.jdt.internal.compiler.lookup.ArrayBinding binding) {
		this.binding = binding;
	}

	public ArrayTypeBinding(
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding,
		int extraDims) {
		this.binding = binding;
		this.extraDims = extraDims;
	}

/*
	public ArrayTypeBinding(ITypeBinding component, int extraDims) {
		this.binding = component.binding;
		this.extraDims = component.extraDims + extraDims;
	}
*/
	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isPrimitive()
	 */
	public boolean isPrimitive() {
		return false;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isNullType()
	 */
	public boolean isNullType() {
		return false;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isArray()
	 */
	public boolean isArray() {
		return true;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#getElementType()
	 */
	public ITypeBinding getElementType() {
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding element;
		if (binding
			instanceof org.eclipse.jdt.internal.compiler.lookup.ArrayBinding) {
			element = ((ArrayBinding) binding).leafComponentType();
		} else {
			element = binding;
		}
  	return BindingFactory.getTypeBinding(element);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#getDimensions()
	 */
	public int getDimensions() {
		return extraDims
			+ ((binding.isArrayType()) ? ((ArrayBinding) binding).dimensions : 0);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getName()
	 */
	public String getName() {
		String name = getElementType().getName();
		for (int i = 0; i < getDimensions(); i++) {
			name += ARRAY_INDICATOR;
		}
		return name;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getKind()
	 */
	public int getKind() {
		return IBinding.TYPE;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#equals(com.sap.tc.jtools.jlint.jom.interfaces.IBinding)
	 */
	public boolean equals(Object object) {
		return (object instanceof ArrayTypeBinding)
			&& (((ArrayTypeBinding) object).binding.equals(binding))
			&& (((ArrayTypeBinding) object).extraDims == extraDims);
	}
  
  public int hashCode() {
    return binding.hashCode() + extraDims * 37;
  }

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isReference()
	 */
	public boolean isReference() {
		return false;
	}

 

}
