/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ArrayInitializer.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.Expression;

import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ArrayInitializer implements IArrayInitializer {

	private org.eclipse.jdt.internal.compiler.ast.ArrayInitializer ai;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	List expressions;

	public ArrayInitializer(
		org.eclipse.jdt.internal.compiler.ast.ArrayInitializer ai,
		BlockScope scope,
		SourceContent source) {
		this.ai = ai;
		this.scope = scope;
		this.source = source;
	}

	public int getNodeType() {
		return Traversable.ARRAY_INITIALIZER;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer#expressions()
	 */
	public List expressions() {
		if (expressions == null) {
			expressions = new Vector();
			Expression[] expressionArray = ai.expressions;
			if (expressionArray != null) {
				for (int i = 0; i < expressionArray.length; i++) {
					expressions.add(
						Wrapper.wrapExpression(
							expressionArray[i],
							scope,
							source));
				}
			}
		}
		return expressions;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(ai.binding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ai.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			List expressions = expressions();
			if (expressions != null) {
				Iterator iterator = expressions.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
		}
		visitor.endVisit(this);
	}

}
