/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ArrayCreation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;

import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ArrayCreation implements IArrayCreation {

	private ArrayAllocationExpression expr;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private IArrayType type;
	private List dimensions;
	private IArrayInitializer initializer;

	public ArrayCreation(
		ArrayAllocationExpression expr,
		BlockScope scope,
		SourceContent source) {
		this.expr = expr;
		this.scope = scope;
		this.source = source;
	}

	public int getNodeType() {
		return Traversable.ARRAY_CREATION;
	}

	public IArrayType getType() {
		if (type == null) {
			type =
				new ArrayTypeFromTypeReference(
					expr.type,
					expr.dimensions.length);
		}
		return type;
	}

	public List dimensions() {
		if (dimensions == null) {
			dimensions = new Vector();
			Expression[] expressions = expr.dimensions;
			if (expressions != null) {
				for (int i = 0; i < expressions.length; i++) {
					dimensions.add(
						Wrapper.wrapExpression(expressions[i], scope, source));
				}
			}
		}
		return dimensions;
	}

	public IArrayInitializer getInitializer() {
		if (initializer == null && expr.initializer != null) {
			initializer = new ArrayInitializer(expr.initializer, scope, source);
		}
		return initializer;
	}

	public ITypeBinding resolveTypeBinding() {
		return getType().resolveBinding();
	}

	public int getStartPosition() {
		return expr.sourceStart;
	}

	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getType().traverse(visitor);
			List dimensions = dimensions();
			if (dimensions != null) {
				Iterator iterator = dimensions.iterator();
				while (iterator.hasNext()) {
					Traversable current = (Traversable) iterator.next();
					if (current != null)
						current.traverse(visitor);
				}
			}
			IArrayInitializer initializer = getInitializer();
			if (initializer != null)
				initializer.traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
