/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/ArrayAccess.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class ArrayAccess implements IArrayAccess {

	private ArrayReference ar;
	private BlockScope scope;
	private SourceContent source;

	/* attribute cache */
	private IExpression array;
	private IExpression index;	
	
	public ArrayAccess(
		ArrayReference ar,
		BlockScope scope,
		SourceContent source) {
		this.ar = ar;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.ARRAY_ACCESS;
	}

	public int getStartPosition() {
		return ar.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess#getArray()
	 */
	public IExpression getArray() {
		if ( array == null ) {
			array = Wrapper.wrapExpression(ar.receiver, scope, source);
		}
		return array;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess#getIndex()
	 */
	public IExpression getIndex() {
		if ( index == null ) {
			index = Wrapper.wrapExpression(ar.position, scope, source);
		}
		return index;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		// type of the whole expression is the type of the array expression with one less dimension

		ITypeBinding tb = getArray().resolveTypeBinding();
		if (!(tb instanceof ArrayTypeBinding)) {
			return null;
		}
		if (tb == null)
			return null; //unresolved binding
		return getComponentType((ArrayTypeBinding) tb);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {

		if (visitor.visit(this)) {
			getArray().traverse(visitor);
			getIndex().traverse(visitor);
		}
		visitor.endVisit(this);
	}

	private ITypeBinding getComponentType(ArrayTypeBinding at) {
		int dim = at.getDimensions();
		if (dim == 1) {
			return at.getElementType();
		} else {
			return new ArrayTypeBinding(at.binding, dim - 1);
		}
	}

}
