/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/AnonymousClassDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Clinit;

import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class AnonymousClassDeclaration implements IAnonymousClassDeclaration {

	public AnonymousLocalTypeDeclaration acd;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private List bodyDeclarations;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed= false;
	
	public AnonymousClassDeclaration(
		AnonymousLocalTypeDeclaration acd,
		BlockScope scope,
		SourceContent source) {
		this.acd = acd;
		this.scope = scope;
		this.source = source;

		/* set bindings */

		/* a) methods */
		AbstractMethodDeclaration[] temp = acd.methods;
		if (temp != null) {
			for (int i = 0; i < temp.length; i++) {
				if (temp[i]
					instanceof org.eclipse.jdt.internal.compiler.ast.MethodDeclaration) {
					org
						.eclipse
						.jdt
						.internal
						.compiler
						.ast
						.MethodDeclaration methodDeclaration =
						(org
							.eclipse
							.jdt
							.internal
							.compiler
							.ast
							.MethodDeclaration) temp[i];
					temp[i].binding.returnType =
						methodDeclaration.returnType.resolveType(temp[i].scope);
					Argument[] arguments = temp[i].arguments;
					if (arguments != null) {
						temp[i].binding.parameters =
							new org
								.eclipse
								.jdt
								.internal
								.compiler
								.lookup
								.TypeBinding[arguments
								.length];
						for (int ii = 0; ii < arguments.length; ii++) {
							org
								.eclipse
								.jdt
								.internal
								.compiler
								.lookup
								.TypeBinding tb =
								arguments[ii].type.getTypeBinding(acd.scope);
							arguments[ii].bind(temp[i].scope, tb, false);
							temp[i].binding.parameters[ii] = tb;
						}
					}
					TypeReference[] exceptions = temp[i].thrownExceptions;
					if (exceptions != null) {
						temp[i].binding.thrownExceptions =
							new ReferenceBinding[exceptions.length];
						for (int ii = 0; ii < exceptions.length; ii++) {
							temp[i].thrownExceptions[ii].resolve(temp[i].scope);
							temp[i].binding.thrownExceptions[ii] =
								(
									ReferenceBinding) temp[i]
										.thrownExceptions[ii]
										.resolvedType;
						}
					}
				}
			}
		}
		/* b) fields */
		org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields =
			acd.fields;
		if (fields != null) {
			for (int i = 0; i < fields.length; i++) {
				if (fields[i]
					instanceof org.eclipse.jdt.internal.compiler.ast.Initializer) {
					(
						(
							org
								.eclipse
								.jdt
								.internal
								.compiler
								.ast
								.Initializer) fields[i])
								.resolve(
						acd.initializerScope);
					continue;
				}
				fields[i].binding.type =
					fields[i].type.getTypeBinding(acd.scope);
				if (fields[i].isStatic()) {
					fields[i].resolve(acd.staticInitializerScope);
				} else {
					fields[i].resolve(acd.initializerScope);
				}
			}
		}
	}

	public int getStartPosition() {
		return acd.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration#bodyDeclarations()
	 */
	public List bodyDeclarations() {
		if (bodyDeclarations == null) {
			/* we want to order members according to their position in source code */
			bodyDeclarations = new Vector() {
				public boolean add(Object o) {
					int position = ((Position) o).getStartPosition();
					int currentSize = size();
					for (int i = 0; i < currentSize; i++) {
						if (position
							< ((Position) get(i)).getStartPosition()) {
							add(i, o);
							return true;
						}
					}
					return super.add(o);
				}
			};

			/* a) add fields and instance initializers */
			org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields =
				acd.fields;
			if (fields != null) {
				for (int i = 0; i < fields.length; i++) {
					if (fields[i]
						instanceof org.eclipse.jdt.internal.compiler.ast.Initializer) {
						//initializer
						bodyDeclarations.add(
							new InitializerFromInitializer(
								(org
									.eclipse
									.jdt
									.internal
									.compiler
									.ast
									.Initializer) fields[i],
								acd.initializerScope,
								source));
					} else { //field
						bodyDeclarations.add(
							new FieldDeclaration(
								fields[i],
								acd.initializerScope,
								source));
					}
				}

			}

			/* b) add methods and class initializers */
			AbstractMethodDeclaration[] methods = acd.methods;
			if (methods != null) {
				for (int i = 0; i < methods.length; i++) {
					if (methods[i] instanceof Clinit) { //class initializer
						bodyDeclarations.add(
							new InitializerFromClinit(
								(Clinit) methods[i],
								acd.initializerScope,
								source));
					} else { //method  
						if (!methods[i].isConstructor()) {
							// constructors make no sense for anonymous classes
							bodyDeclarations.add(
								new MethodDeclaration(
									methods[i],
									acd.initializerScope,
									source));
						}
					}
				}
			}
			/* c) add member types */
			org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration[] types =
				acd.memberTypes;
			if (types != null) {
				for (int i = 0; i < types.length; i++) {
					bodyDeclarations.add(new TypeDeclaration(types[i], source));
				}
			}
		}
		return bodyDeclarations;

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration#resolveBinding()
	 */
	public IReferenceTypeBinding resolveBinding() {
		return BindingFactory.getReferenceTypeBinding(acd.binding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			List declarations = bodyDeclarations();
			if (declarations != null) {
				Iterator iterator = declarations.iterator();
				while (iterator.hasNext()) {
					Object current = iterator.next();
					if (!((current instanceof IMethodDeclaration)
						&& ((IMethodDeclaration) current).isConstructor())) {
						// we don't want to visit the default constructor
						 ((Traversable) current).traverse(visitor);
					}
				}
			}
		}
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.ANONYMOUS_CLASS_DECLARATION;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Commentable#getComments()
	 */
	public IComment[] getComments() {
		if ( comments == null ) {
			comments = source.getBlockComment(acd.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Commentable#getEndOfLineComment()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(acd.bodyStart - 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
