/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/JomTestVisitorWithFlow.java#2 $
 */

package com.sap.tc.jtools.jlint.jom;

import java.util.HashMap;
import java.util.Map;

import com.sap.tc.jtools.jlint.java.flow.BooleanFlowLineMethod;
import com.sap.tc.jtools.jlint.java.flow.Flow;
import com.sap.tc.jtools.jlint.java.flow.FlowInterface;
import com.sap.tc.jtools.jlint.java.flow.FlowLine;
import com.sap.tc.jtools.jlint.java.flow.FlowLineManipulator;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;

abstract public class JomTestVisitorWithFlow extends JomTestVisitor {

	private Map flowPre = new HashMap();
	private Map flowPost = new HashMap();

	private FlowInterface currentFlow = new Flow();

	abstract public boolean visitExternal(IIfStatement stmt);
	
	public final boolean visit(IIfStatement stmt) {
		flowPre.put(stmt, currentFlow);
		boolean out = visitExternal(stmt);
		flowPost.put(stmt.getExpression(), currentFlow);
		return out;
	}
	
	public final void endVisit(IBlock block) {
		boolean out = endVisitExternal(block);
		flowPost.put(block, currentFlow);
	}

	/**
	 * @param block
	 * @return
	 */
	private boolean endVisitExternal(IBlock block) {
		return true;
	}

	abstract public void endVisitExternal(IIfStatement stmt);
	
	public final void endVisit(IIfStatement stmt) {
		IStatement thenStmt = stmt.getThenStatement();
		FlowInterface outThen = (FlowInterface) flowPost.get(thenStmt);
		if (stmt.getElseStatement() != null) {
			outThen.addFlowLines((FlowInterface) flowPost.get(stmt.getElseStatement()));
			currentFlow = outThen;
		} else {
			outThen.addFlowLines((FlowInterface) flowPost.get(stmt.getExpression()));
			currentFlow = outThen;
		}
		endVisitExternal(stmt);
	}

	public final void manipulateFlow(String type, FlowLineManipulator manipulator) {
		FlowInterface clone = (FlowInterface) currentFlow.clone();
		currentFlow = clone.manipulateFlowLine(type, manipulator);
	}

	public final void addFlowLine(String type, FlowLine flowLine) {
		currentFlow.addFlowLine(type, flowLine);
	}
	
	public final boolean check(String type, BooleanFlowLineMethod checkMethod) {
		return currentFlow.isAlwaysTrue(type,checkMethod);
	}
	
	public final void resetFlow(String type) {
		currentFlow.resetFlowLines(type);
	}

}
