/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/JomSyntaxTreeRequirement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom;

import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;

import com.sap.tc.jtools.jlint.ProcessorInterface;
import com.sap.tc.jtools.jlint.RequirementInterface;
import com.sap.tc.jtools.jlint.jdt.ClasspathLocation;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * @author I024087
 */
public class JomSyntaxTreeRequirement implements RequirementInterface {

  private static final String JST_PAR_FILENAME = "filename";

  private ParameterInterface[] parameters;
  private ProcessorInterface processor;
  private String fileName;
  private ClasspathLocation[] searchPaths;
  private LookupEnvironment lue;
  private INameEnvironment environment;

  public JomSyntaxTreeRequirement(
    String fileName,
    ClasspathLocation[] searchPaths,
    LookupEnvironment lue,
    INameEnvironment environment) {
    this.fileName = fileName;
    this.searchPaths = searchPaths;
    this.lue = lue;
    this.environment = environment;
    parameters = new ParameterInterface[1];
    parameters =
      new ParameterInterface[] {
         ParameterTool.createParameter(
          JST_PAR_FILENAME,
          ParameterTool.PAR_TYPE_STRING,
          fileName)};
  }
  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.RequirementInterface#getClassName()
   */
  public String getClassName() {
    return getClass().getName();
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.RequirementInterface#getParameters()
   */
  public ParameterInterface[] getParameters() {
    return parameters;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.RequirementInterface#getProcessor()
   */
  public ProcessorInterface getProcessor() {
    if (processor == null) {
      processor =
        new JomParserProcessor(fileName, searchPaths, environment, lue);
    }
    return processor;
  }

}
