/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/JomProjectVisitorProcessor.java#2 $
 */

package com.sap.tc.jtools.jlint.jom;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;

import com.sap.tc.jtools.jlint.ProcessorUnitInterface;
import com.sap.tc.jtools.jlint.RequirementInterface;
import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.TestProcessorInterface;
import com.sap.tc.jtools.jlint.exceptions.ExecutionException;
import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jlint.jdt.ClasspathLocation;
import com.sap.tc.jtools.jlint.jdt.MyTypeRequestor;
import com.sap.tc.jtools.jlint.jdt.NameEnvironment;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.exceptions.CancelJobException;
import com.sap.tc.jtools.jtci.interfaces.Listener;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;

/**
 * Test processor (visitor) for Jom-tests.
 * <p>
 * It implements TestProcessorInterface.
 * <p>
 * It collects all the Jom-tests that have to be performed on the same
 * sources. The actual visiting is done by rootVisitor (which instantiates the class 
 * JomVisitor).
 *
 * It depends on the following parameters:
 * <ul>
 * <li>array of files to be tested (arranged in an object of type 
 *     com.sap.tc.jtools.jlint.JavaFileArrayTestObject)</li>
 * <li>class path locations</li>
 * </ul>
 * <p>
 * In order to be executed, it requires:
 * <ul>
 * <li>syntax trees (instances of com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit)
 * of all the files to be tested</li>
 * </ul>
 * 
 */

public class JomProjectVisitorProcessor implements TestProcessorInterface {
	public final static String CLASS_NAME = "com.sap.tc.jtools.jlint.jom.JomProjectVisitorProcessor"; //$NON-NLS-1$

	public final static String ROLE_JOM_VISITOR = "jom visitor"; //$NON-NLS-1$ 
	public final static String REQUIREMENT_JOM_SYNTAX_TREE = "jom syntax tree"; //$NON-NLS-1$ 
	public final static String JST_PAR_FILENAME = "filename"; //$NON-NLS-1$ 

	public final static String SEPARATOR = "/"; //$NON-NLS-1$
	private JomVisitor rootVisitor = new JomVisitor();
	private Vector testVisitors = new Vector();
	private Vector errors = new Vector();
	private ParameterInterface[] parameter = new ParameterInterface[1];
	private ICompilationUnit[] syntaxTrees = null;
	protected ClasspathLocation[] searchPaths;
	private JavaFileArrayTestObject testObject;
	private LookupEnvironment lue;
	private INameEnvironment environment;
	private Listener listener;

	public JomProjectVisitorProcessor(
		JavaFileArrayTestObject testObject,
		ClasspathLocation[] searchPaths) {
		this.testObject = testObject;
		parameter[0] =
			ParameterTool.createParameter(
				PARAMETER_TARGET_FILE_LIST,
				ParameterTool.PAR_TYPE_STRING_ARRAY,
				testObject.getFileNames());
		this.searchPaths = searchPaths;

		//		if (lue == null) {
		environment = new NameEnvironment(searchPaths);
		MyTypeRequestor typeRequestor = new MyTypeRequestor();
		/*LookupEnvironment */
		lue =
			new LookupEnvironment(
				typeRequestor,
				new CompilerOptions(),
				null,
				environment);
		typeRequestor.lue = lue;
		//		}
	}

	public TestObject getTestObject() {
		return testObject;
	}

	public String getName() {
		return CLASS_NAME;
	}

	public ParameterInterface[] getParameters() {
		return parameter;
	}

	public Object getData() { //todo  change this
		return null;
	}

	public ResultInterface[] getErrors() { //todo  change this
		java.util.Vector resultVector = new java.util.Vector();
		Iterator tests = testVisitors.iterator();
		while (tests.hasNext()) {
			List res = ((JomTestVisitor) tests.next()).getErrorList();
			if (res != null) {
				for (Iterator iter = res.iterator(); iter.hasNext();) {
					Result element = (Result) iter.next();
					resultVector.add(element);
				}
			}
		}

		Vector res2 = rootVisitor.getErrors();
		for (int i = 0; i < res2.size(); i++)
			resultVector.add(res2.elementAt(i));
		for (Iterator iter = errors.iterator(); iter.hasNext();) {
			resultVector.add((Result) iter.next());
		}

		return (Result[]) resultVector.toArray(new Result[resultVector.size()]);
	}

	public void addProcessorUnit(
		ProcessorUnitInterface processorUnit,
		String role) {
		if (!role.equals(ROLE_JOM_VISITOR))
			return;
		testVisitors.add(processorUnit);
	}

	public void execute() throws ExecutionException {
		// attach visitors
		Iterator tests = testVisitors.iterator();
		while (tests.hasNext()) {
			rootVisitor.addVisitor((ITestVisitor) tests.next());
		}

		/*		for (int i = 0; i < syntaxTrees.length; i++) {
					if (syntaxTrees[i] != null
						&& syntaxTrees[i] instanceof CompilationUnit)
						lue.buildTypeBindings(((CompilationUnit) syntaxTrees[i]).cud);
				} */
		lue.completeTypeBindings();
		for (int i = 0; i < syntaxTrees.length; i++) {
			try {
				syntaxTrees[i].traverse(rootVisitor);
			} catch (Exception e) {
				String baseDir = testObject.getBaseDir();
				String fileName;
				if (baseDir == null) {
					fileName = syntaxTrees[i].getFileName();
				} else {
					fileName =
						syntaxTrees[i].getFileName().substring(
							baseDir.length() + 1);
				}
				StringWriter stackTraceWriter = new StringWriter();
				e.printStackTrace(new PrintWriter(stackTraceWriter));
				Properties p = new Properties();
				p.setProperty(
					ParameterTool.PAR_EXCEPTION,
					stackTraceWriter.toString());
				p.setProperty(
					ParameterTool.PAR_MSG_KEY,
					Result.ERROR_MESSAGE_SYNTAX_ERROR);
				errors.add(
					new Result(
						this.getName(),
						testObject.getType(),
						testObject.getID(),
						JavaFileArrayTestObject.getPosition(fileName),
						Result.SEVERITY_INTERNAL_ERROR,
						Result.ERROR_MESSAGE_SYNTAX_ERROR,
						p));
			}
			if (listener != null) {
				listener.processedTestObjectComponent();
				if (listener.isCanceled()) {
					throw new CancelJobException();
				}
			}
		}
		// clear binding cache
		BindingFactory.clearCache();
	}

	public RequirementInterface[] getRequirements() {
		String[] files = testObject.getFileNames();
		RequirementInterface[] reqs = new RequirementInterface[files.length];
		for (int i = 0; i < reqs.length; i++) {

			final String currentSource;
			if (testObject.getBaseDir() == null)
				currentSource = files[i];
			else
				currentSource = testObject.getBaseDir() + SEPARATOR + files[i];
			reqs[i] =
				new JomSyntaxTreeRequirement(
					currentSource,
					searchPaths,lue,
					environment);
		}

		return reqs;
	}

	public void setPrerequisites(Object[] reqs) {
		syntaxTrees = new ICompilationUnit[reqs.length];
		for (int i = 0; i < reqs.length; i++) {
			syntaxTrees[i] = (ICompilationUnit) reqs[i];
		}
	}

	public void setListener(Listener listener) {
		this.listener = listener;
	}

}
