/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/JomParserProcessor.java#3 $
 */

package com.sap.tc.jtools.jlint.jom;

import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.core.CompilationUnitVisitor;

import com.sap.tc.jtools.jlint.ExternalFileRequirement;
import com.sap.tc.jtools.jlint.ProcessorInterface;
import com.sap.tc.jtools.jlint.ProcessorUnitInterface;
import com.sap.tc.jtools.jlint.RequirementInterface;
import com.sap.tc.jtools.jlint.exceptions.ExecutionException;
import com.sap.tc.jtools.jlint.jdt.ClasspathLocation;
import com.sap.tc.jtools.jlint.jdt.JdtCompilerRequestor;
import com.sap.tc.jtools.jlint.jdt.JdtErrorHandlingPolicy;
import com.sap.tc.jtools.jlint.jdt.JdtProblemFactory;
import com.sap.tc.jtools.jlint.jdt.JdtSource;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.CompilationUnit;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.Listener;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * Test processor (parser) for Jom-tests.
 * <p>
 * It implements TestProcessorInterface.
 * <p>
 * It employs the jdt framework to produce a tree of type 
 * org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration,
 * which is then wrapped into an instance of
 * com.sap.tc.jtools.jlint.jom.ciwrappers.CompilationUnit.
 * <p>
 * It depends on the following parameters:
 * <ul>
 * <li>name of the file to be parsed</li>
 * <li>class path locations</li>
 * </ul>
 * <p>
 * In order to be executed, it requires:
 * <ul>
 * <li>the file with the given name</li>
 * </ul>
 */

public class JomParserProcessor implements ProcessorInterface {

	static public final String CLASS_NAME = "com.sap.tc.jtools.jlint.jdt.JomParserProcessor"; //$NON-NLS-1$
	private LookupEnvironment lue; 
	private INameEnvironment environment; 
	// search paths --> environment
	private String filename = null;
	private ParameterInterface[] parameter = new ParameterInterface[1];
	private CompilationUnitDeclaration syntaxTree = null;
	private ClasspathLocation[] searchPaths = null;
	private char[] source = null;

	public JomParserProcessor(String filename, ClasspathLocation[] sp, INameEnvironment environment, LookupEnvironment lue) {
		this.filename = filename;
		this.lue = lue;
		this.environment = environment;
		parameter[0] =
			ParameterTool.createParameter(
				PARAMETER_TARGET_FILE,
				ParameterTool.PAR_TYPE_STRING,
				filename);
		searchPaths = sp;
	}

	public String getName() {
		return CLASS_NAME;
	}

	public ParameterInterface[] getParameters() {
		return parameter;
	}

	public Object getData() {
		if (syntaxTree != null)
			return new CompilationUnit(syntaxTree, source);
		return null;
	}

	public void execute() throws ExecutionException {

		ICompilationUnit cuSource = null;
		FileReader fr = null;
		try {
			fr = new FileReader(filename);

			cuSource = new JdtSource(fr, filename);
			source = cuSource.getContents();

 
			IErrorHandlingPolicy policy = new JdtErrorHandlingPolicy();
			Map settings = new HashMap();
			ICompilerRequestor requestor = new JdtCompilerRequestor();

			final IProblemFactory problemFactory = new JdtProblemFactory();

			CompilationUnitVisitor cuVisitor =
				new CompilationUnitVisitor(
					environment,
					policy,
					settings,
					requestor,
					problemFactory);
			CompilationResult cr = null;

			char[] outFile = filename.toCharArray();
			cr = new CompilationResult(outFile, 0, 0, 1000);
			syntaxTree =
				cuVisitor.parser.parse(
					cuSource,
					cr,
					0,
					cuSource.getContents().length - 1);
			lue.buildTypeBindings(syntaxTree);
		} catch (Exception e) {
			throw new ExecutionException();
		} finally {
			try {
				fr.close();
			} catch (IOException e) { //$JL-EXC$
			}
		}

	}

	public void addProcessorUnit(
		ProcessorUnitInterface processorUnit,
		String role) {
		// nothing to do
	}

	public RequirementInterface[] getRequirements() {
		ExternalFileRequirement[] reqs = new ExternalFileRequirement[1];
		reqs[0] = new ExternalFileRequirement(filename);
		return reqs;
	}

	public void setPrerequisites(Object[] reqs) {
	}

	/**
	 * @see com.sap.tc.jtools.jlint.ProcessorInterface#setListener(Listener)
	 */
	public void setListener(Listener listener) {
	}

}
