/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jdt/MyTypeRequestor.java#3 $
 */

package com.sap.tc.jtools.jlint.jdt;

import java.io.*;
import java.util.*;
import org.eclipse.jdt.internal.compiler.impl.*;
import org.eclipse.jdt.internal.compiler.*;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.core.CompilationUnitVisitor;
import org.eclipse.jdt.internal.compiler.lookup.*;

public class MyTypeRequestor implements ITypeRequestor {
	public LookupEnvironment lue;
	public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
		lue.createBinaryTypeFrom(binaryType, packageBinding);
	}

	public void accept(ICompilationUnit unit) {

		INameEnvironment environment =
			new NameEnvironment(new ClasspathLocation[0]);
		IErrorHandlingPolicy policy = new JdtErrorHandlingPolicy();
		Map settings = new HashMap();
		ICompilerRequestor requestor = new JdtCompilerRequestor();

		IProblemFactory problemFactory = new JdtProblemFactory();

		CompilationUnitVisitor cuVisitor =
			new CompilationUnitVisitor(
				environment,
				policy,
				settings,
				requestor,
				problemFactory);

		JdtSource cuSource;
		try {
			cuSource =
				new JdtSource(
					new FileReader(new String(unit.getFileName())),
					new String(unit.getFileName()));

			// diet parsing for large collection of unit
			CompilationUnitDeclaration parsedUnit;
			CompilationResult cr = null;

			char[] outFile = unit.getFileName();
			cr = new CompilationResult(outFile, 0, 0, 1000);

			parsedUnit =
				cuVisitor.parser.parse(cuSource, cr, 0, cuSource.getContents().length -1);

			// initial type binding creation
			lue.buildTypeBindings(parsedUnit);
			lue.completeTypeBindings(parsedUnit);
		} catch (FileNotFoundException e) { // $JL-EXC$
		}
	}
	public void accept(
		ISourceType[] sourceType,
		PackageBinding packageBinding) {

	}
}