/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jdt/JdtSource.java#2 $
 */

package com.sap.tc.jtools.jlint.jdt;

import java.io.*;

import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

/**
 * @author d034036
 */
public class JdtSource implements ICompilationUnit {

 
    private char[] fileName;
    private char[] out;
    public static final int MAX_SIZE = 2000000;
    public static final int INITIAL_SIZE = 200;
        
    public JdtSource(FileReader fr, String fileName) {
 
        this.fileName = fileName.toCharArray();
        int size = INITIAL_SIZE;

        String outString = "";
        int rc = 0;
        while ( rc != -1 && size < MAX_SIZE ){
            out = new char[size];
            try {
                rc = fr.read(out);
                if ( rc != size ) rc = -1;
                outString += new String(out);
                size *= 2;
            } catch (Exception e) {
                e.printStackTrace();
                rc = -1;
            }
            out = outString.trim().toCharArray();
        }
    }
    
    public char[] getContents() {
        return out;
    }
    
    public char[] getMainTypeName() {
        return null;
    }
    
    public char[][] getPackageName() {
        return null;
    }
    
    public char[] getFileName() {
        return fileName;
    }

}
