/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jdt/JdtProblemFactory.java#2 $
 */

package com.sap.tc.jtools.jlint.jdt;

import java.util.Locale;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;

/**
 * @author d034036
 */
public class JdtProblemFactory implements IProblemFactory {

	public IProblem createProblem(
		char[] originatingFileName,
		int problemId,
		String[] arguments,
		int severity,
		int startPosition,
		int endPosition,
		int lineNumber) {
		return new DefaultProblem(originatingFileName,
		"parsing error",
		problemId,
		arguments,
		severity,
		startPosition,
		endPosition,
		lineNumber);
	}

	public IProblem createProblem(
		char[] originatingFileName,
		int problemId,
		String[] problemArguments,
		String[] messageArguments, // shorter versions of the problemArguments
		int severity,
		int startPosition,
		int endPosition,
		int lineNumber) {
			return new DefaultProblem(originatingFileName,
			"parsing error",
			problemId,
			problemArguments,
			severity,
			startPosition,
			endPosition,
			lineNumber);
	}
	public Locale getLocale() {
		return null;
	}

	public String getLocalizedMessage(
		int problemId,
		String[] problemArguments) {
		//todo: resource bundles??
		return null;
	}



}
