/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jdt/ClasspathMultiDirectory.java#3 $
 */

package com.sap.tc.jtools.jlint.jdt;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.File;
import java.io.IOException;

import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

class ClasspathMultiDirectory extends ClasspathDirectory {

	String sourcePath;

	ClasspathMultiDirectory(String sourcePath, String binaryPath) {
		super(binaryPath);

		this.sourcePath = sourcePath;
		if (!sourcePath.endsWith("/")) //$NON-NLS-1$
			this.sourcePath += "/"; //$NON-NLS-1$
	}

	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (!(o instanceof ClasspathMultiDirectory))
			return false;

		ClasspathMultiDirectory md = (ClasspathMultiDirectory) o;
		return binaryPath.equals(md.binaryPath)
			&& sourcePath.equals(md.sourcePath);
	}

	NameEnvironmentAnswer findSourceFile(
		String qualifiedSourceFileName,
		String qualifiedPackageName,
		char[] typeName,
		String[] additionalSourceFilenames) {

		// if an additional source file is waiting to be compiled, answer it
		// BUT not if this is a secondary type search,
		// if we answer the source file X.java which may no longer define Y
		// then the binary type looking for Y will fail & think the class path is wrong
		// let the recompile loop fix up dependents when Y has been deleted from X.java
		String fullSourceName = sourcePath + qualifiedSourceFileName;
		File f = new File(fullSourceName);
		if (f.exists())
			try {
				if (f.getCanonicalPath().replace('\\','/').endsWith(qualifiedSourceFileName))
					return new NameEnvironmentAnswer(
						new JdtSource(
							new FileReader(fullSourceName),
							fullSourceName));
			} catch (IOException e) { //$JL-EXC$
			}
		for (int i = 0, l = additionalSourceFilenames.length; i < l; i++) {
			if (fullSourceName.equals(additionalSourceFilenames[i])) {
				try {
					return new NameEnvironmentAnswer(
						new JdtSource(
							new FileReader(fullSourceName),
							fullSourceName));
				} catch (FileNotFoundException e) { // $JL-EXC$
				}
			}
		}
		return null;
	}

	public String toString() {
		return "Source classpath directory " + sourcePath + //$NON-NLS-1$
		" with binary directory " + binaryPath; //$NON-NLS-1$
	}
}