/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jdt/ClasspathJar.java#3 $
 */

package com.sap.tc.jtools.jlint.jdt;

import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
 

import java.io.*;
import java.util.*;
import java.util.zip.*;

class ClasspathJar extends ClasspathLocation {

String zipFilename; // keep for equals
ZipFile zipFile;
/*gfb 2.0 ->2.1SimpleLookupTable*/ HashMap packageCache;	

ClasspathJar(String zipFilename) {
	this.zipFilename = zipFilename;
	this.zipFile = null;
	this.packageCache = null;
}

void cleanup() {
	if (zipFile != null) {
		try { 
			zipFile.close(); 
		} catch(IOException e) {//$JL-EXC$
		}
		this.zipFile = null;
	}
	this.packageCache = null;
}

public boolean equals(Object o) {
	if (this == o) return true;
	if (!(o instanceof ClasspathJar)) return false;

	return zipFilename.equals(((ClasspathJar) o).zipFilename);
} 

NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
	if (!isPackage(qualifiedPackageName)) return null; // most common case

	try {
		ClassFileReader reader = ClassFileReader.read(zipFile, qualifiedBinaryFileName);
		if (reader != null) return new NameEnvironmentAnswer(reader);
	} catch (Exception e) { //$JL-EXC$
//		treat as if class file is missing
	} 
	return null;
}

boolean isPackage(String qualifiedPackageName) {
	if (packageCache != null)
		return packageCache.containsKey(qualifiedPackageName);

//gfb 2.0 -> 2.1	this.packageCache = new SimpleLookupTable(41);
  this.packageCache = new HashMap();

	packageCache.put("", ""); //$NON-NLS-1$ //$NON-NLS-2$
	try {
		this.zipFile = new ZipFile(zipFilename);

		nextEntry : for (Enumeration e = zipFile.entries(); e.hasMoreElements(); ) {
			String fileName = ((ZipEntry) e.nextElement()).getName();
	
			// add the package name & all of its parent packages
			int last = fileName.lastIndexOf('/');
			while (last > 0) {
				// extract the package name
				String packageName = fileName.substring(0, last);
				if (packageCache.containsKey(packageName))
					continue nextEntry;
				packageCache.put(packageName, packageName);
				last = packageName.lastIndexOf('/');
			}
		}
		return packageCache.containsKey(qualifiedPackageName);
	} catch(IOException e) { //$JL-EXC$
	}
	return false;
}

public String toString() {
	return "Classpath jar file " + zipFilename; //$NON-NLS-1$
}
}