/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/javaelements/MethodInterface.java#1 $
 */
 
package com.sap.tc.jtools.jlint.javaelements;

/**
 * Abstract representation of a method/constructor. 
 * 
 * @author d034036
 *
 */
public interface MethodInterface {
	/**
	 * returns the method modifers (in the encoding of java.lang.reflect.Modifier)
	 * 
	 * @return modifiers
	 */
	public int getModifiers();
	
	/**
	 * returns the fully-qualified exception type names.
	 * 
	 * @return exceptions
	 */
	public String[] getExceptionTypes();
	
	/**
	 * returns the method name (<code>null</code> if the object represents a constructor)
	 * 
	 * @return method name
	 */
	public String getMethodName();
	
	/**
	 * returns <code>true</code> if the object represents a constructor.
	 * 
	 * @return <code>true</code> if the object represents a constructor.
	 */	
	public boolean isConstructor();

	/**
	 * returns the fully-qualified parameter type names.
	 * 
	 * @return parameters
	 */
	public String[] getParameterTypes();
	
	/**
	 * returns the fully-qualified return type names.
	 * 
	 * @return return type
	 */
	public String getReturnType();
	
	/**
	 * returns the defining class/interface.
	 * 
	 * @return defining class
	 */
	public ClassInterface getDefiningClass();
}
