/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/javaelements/FieldInterface.java#1 $
 */
 
package com.sap.tc.jtools.jlint.javaelements;

/**
 * Abstract representation of a field. 
 * 
 * @author d034036
 *
 */
public interface FieldInterface {
	/**
	 * returns the field modifers (in the encoding of java.lang.reflect.Modifier)
	 * 
	 * @return modifiers
	 */
	public int getModifiers();
	
	/**
	 * returns the field name.
	 * 
	 * @return name
	 */	
	public String getName();
	
	/**
	 * returns the fully-qualified type name.
	 * 
	 * @return type name
	 */		
	public String getType();
	
	/**
	 * returns a string representation of the field value if the field
	 * is a constant, <code>null</code> otherwise.
	 * 
	 * @return field value
	 */		
	public String getValue();
	
	/**
	 * returns the defining class/interface.
	 * 
	 * @return defining class
	 */
	public ClassInterface getDefiningClass();
}
