/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/javaelements/Field.java#1 $
 */
 
package com.sap.tc.jtools.jlint.javaelements;

import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * Implementation of FieldInterface.
 * Instances of this class can be persisted in XML format.
 * 
 * @author d034036
 *
 */
public class Field implements FieldInterface, Persistable {

	private ClassInterface cls;
	private String name;
	private int modifiers;
	private String type;
	private String value;

	public Field(String name, int modifiers, String type, String value) {
		this.name = name;
		this.modifiers = modifiers;
		this.type = type;
		this.value = value;
	}

	public Field(String name, int modifiers, String type) {
		this.name = name;
		this.modifiers = modifiers;
		this.type = type;
	}

	public Field(StructureTree tree, ClassInterface definingClass) {
		name = tree.getParameter("NAME");
		modifiers = Integer.parseInt(tree.getParameter("MODIFIERS"));
		type = tree.getParameter("TYPE");
		String myValue = tree.getParameter("VALUE");
		if("char".equals(type) && myValue != null) {
			// char's are encoded as int's to prevent 
			// XML parsing errors for weird statements like
			// static final char c = 1;
			char c = (char) Integer.parseInt(myValue);
			myValue = new String(new char[]{c});
		} 
		this.value = myValue;
		this.cls = definingClass;
	}

	public StructureTree toStructureTree() {
		Header header = new Header("FIELD");
		header.setParameter("MODIFIERS", Integer.toString(modifiers));
		header.setParameter("NAME", name);
		header.setParameter("TYPE", type);
		if (value != null) {
			if ("char".equals(type)) {
	           // workaround for int values assigned to a char
            	// causing XML parser exceptions: encode as integer
				String encodedValue;
				char[] charArray = value.toCharArray();
				if (charArray.length > 0) {
					// must always be 1, but just to be sure....
     				encodedValue = String.valueOf((int)charArray[0]);
        			header.setParameter("VALUE", encodedValue);
				}
			} else {
     			header.setParameter("VALUE", value);
			}
		}

		return new StructureTree(header);
	}

	public int getModifiers() {
		return modifiers;
	}

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}

	public String getValue() {
		return value;
	}

	public ClassInterface getDefiningClass() {
		return cls;
	}

	public void setDefiningClass(ClassInterface cls) {
		this.cls = cls;
	}

}
