/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/javaelements/ClassInterface.java#1 $
 */
 
package com.sap.tc.jtools.jlint.javaelements;

/**
 * Abstract representation of a Java class/interface. 
 * 
 * @author d034036
 *
 */
public interface ClassInterface {
	/**
	 * returns the class name (including any outer class, but not the package name).
	 * Name components are separated by '.'.
	 *  
	 * @return class name
	 */
	public String getClassName();
	
	/**
	 * returns the '.'-separated full package name.
	 * 
	 * @return package name
	 */
	public String getPckName();
	
	/**
	 * returns the fully-qualified superclass name (or <code>null</code> if
	 * the superclass is "java.lang.Object").
	 * 
	 * @return superclass name
	 */
	public String getSuperclass();

	/**
	 * returns the list of fully-qualified superinterface names.
	 * 
	 * @return superinterfaces
	 */
	public String[] getSuperinterfaces();
	
	/**
	 * returns <code>true</code> if the object represents an interface.
	 * 
	 * @return <code>true</code> if the object represents an interface.
	 */	
	public boolean isInterface();
	
	/**
	 * returns the class modifers (in the encoding of java.lang.reflect.Modifier)
	 * 
	 * @return modifiers
	 */
	public int getModifiers();
		
	/**
	 * returns the member fields.
	 * 
	 * @return member fields
	 */
	public FieldInterface[] getFields();
	
	/**
	 * returns the member methods(constructors.
	 * 
	 * @return member methods
	 */
	public MethodInterface[] getMethods();
	
	/**
	 * returns the member classes/interfaces.
	 * 
	 * @return member classes
	 */
	public ClassInterface[] getInnerClasses();


}
