/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/javadiff/util/APIFilter.java#1 $
 */
 
package com.sap.tc.jtools.jlint.javadiff.util;

import java.lang.reflect.Modifier;

import com.sap.tc.jtools.jlint.javadiff.comparator.FilterInterface;
import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;

/**
 * @author d034036
 *
 * Filter implementation that filters out all private class members.
 */
public class APIFilter implements FilterInterface {
	public boolean ignore(ClassInterface cls) {
		return Modifier.isPrivate(cls.getModifiers());
	}

	public boolean ignore(FieldInterface field) {
		return Modifier.isPrivate(field.getModifiers());
	}

	public boolean ignore(MethodInterface method) {
		return Modifier.isPrivate(method.getModifiers());
	}

}
