/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/javadiff/comparator/ListenerInterface.java#1 $
 */
 
package com.sap.tc.jtools.jlint.javadiff.comparator;

import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;

/**
 * Interface used by the comparator when the two compared elements 
 * are different. The interface has one method for each possible
 * difference type.
 * 
 * TODO: should differences at the package level also be processed here? 
 * 
 * @author d034036
 *
 */
public interface ListenerInterface {

	/**
	 * Class 1 has a field that is missing from Class 2
	 * 
	 * @param field1 the extra field
	 */
	public void extraFieldIn1(FieldInterface field1);

	/**
	 * Class 2 has a field that is missing from Class 1
	 * 
	 * @param field2 the extra field
	 */
	public void extraFieldIn2(FieldInterface field2);

	/**
	 * Class 1 has a method that is missing from Class 2
	 * 
	 * @param method1 the extra method
	 */
	public void extraMethodIn1(MethodInterface method1);

	/**
	 * Class 2 has a method that is missing from Class 1
	 * 
	 * @param method2 the extra method
	 */
	public void extraMethodIn2(MethodInterface method2);


	/**
	 * Class 1 and 2 have a method with the same name but different signatures
	 * 
	 * @param method1: the method in class 1
	 * @param method2: the method in class 2
	 * 	 
	 */
	public void differentMethodSignatures(
		MethodInterface method1,
		MethodInterface method2);

	/**
	 * Class 1 and 2 have different modifiers
	 * 
	 * @param c1: class 1
	 * @param c2: class 2
	 * 	 
	 */
	public void differentClassModifiers(ClassInterface c1, ClassInterface c2);

	/**
	 * Class 1 and 2 have different superclasses
	 * 
	 * @param c1: class 1
	 * @param c2: class 2
	 * 	 
	 */
	public void differentSuperclass(ClassInterface c1, ClassInterface c2);

	/**
	 * Class 1 has a superinterface that is missing from Class 2
	 * 
	 * @param c1 class 1
	 * @param si the extra superinterface
	 */
	public void extraSuperInterfaceIn1(ClassInterface c1, String si);

	/**
	 * Class 2 has a superinterface that is missing from Class 1
	 * 
	 * @param c2 class 2
	 * @param si the extra superinterface
	 */
	public void extraSuperInterfaceIn2(ClassInterface c2, String si);

	/**
	 * Class 1 has an inner class that is missing from Class 2
	 * 
	 * @param c1 class 1
	 * @param cls the extra inner class
	 */
	public void extraClassIn1(ClassInterface c1, ClassInterface cls);

	/**
	 * Class 2 has an inner class that is missing from Class 1
	 * 
	 * @param c2 class 2
	 * @param cls the extra inner class
	 */
	public void extraClassIn2(ClassInterface c2, ClassInterface cls);

	/**
	 * Method 1 and 2 have different modifiers
	 * 
	 * @param m1: method 1
	 * @param m2: method 2
	 * 	 
	 */
	public void differentMethodModifiers(MethodInterface m1, MethodInterface m2);

	/**
	 * Method 1 and 2 have different return types
	 * 
	 * @param m1: method 1
	 * @param m2: method 2
	 * 	 
	 */
	public void differentReturnTypes(MethodInterface m1, MethodInterface m2);

	/**
	 * Method 1 and 2 raise different exceptions
	 * 
	 * @param m1: method 1
	 * @param m2: method 2
	 * 	 
	 */
	public void differentExceptions(MethodInterface m1, MethodInterface m2);

	/**
	 * Field 1 and 2 have different modifiers
	 * 
	 * @param f1: field 1
	 * @param f2: field 2
	 * 	 
	 */
	public void differentFieldModifiers(FieldInterface f1, FieldInterface f2);

	/**
	 * Field 1 and 2 have different types
	 * 
	 * @param f1: field 1
	 * @param f2: field 2
	 * 	 
	 */
	public void differentFieldTypes(FieldInterface f1, FieldInterface f2);

	/**
	 * Field 1 and 2 have different constant values
	 * 
	 * @param f1: field 1
	 * @param f2: field 2
	 * 	 
	 */
	public void differentFieldValues(FieldInterface f1, FieldInterface f2);

 	 

}
