/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/javadiff/comparator/FilterInterface.java#1 $
 */
 
package com.sap.tc.jtools.jlint.javadiff.comparator;

import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;

/**
 * Interface used to exclude classes and class members from the comparator handling.
 * 
 * @author d034036
 *
 */

public interface FilterInterface {
	/**
	 * Returns whether the class has to be ignored by the comparator.
	 * 
	 * @param cls: class
	 * @return whether the class has to be ignored
	 */
	public boolean ignore(ClassInterface cls);

	/**
	 * Returns whether the field has to be ignored by the comparator.
	 * 
	 * @param field: field
	 * @return whether the field has to be ignored
	 */	
	public boolean ignore(FieldInterface field);
	
	/**
	 * Returns whether the method has to be ignored by the comparator.
	 * 
	 * @param method: method
	 * @return whether the method has to be ignored
	 */	
	public boolean ignore(MethodInterface method);	
}
