/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/java/flow/Flow.java#2 $
 */

package com.sap.tc.jtools.jlint.java.flow;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Flow implements FlowInterface {


    public HashMap flowLines = new HashMap();

    public Flow() {
    }

    public void addFlowLines(FlowInterface flow) {
        HashMap flowLinesIn  = ((Flow)flow).flowLines;
        Iterator iterator = flowLinesIn.keySet().iterator();
        while (iterator.hasNext()) {
            Object currentKey = iterator.next();
            if (flowLines.containsKey(currentKey)) {
                ((MyHashSet)flowLines.get(currentKey)).addAll((MyHashSet)flowLinesIn.get(currentKey));
            } else { // add new path type
                flowLines.put(currentKey, flowLinesIn.get(currentKey));
            }
        }
    }

    public void addFlowLine(String type, FlowLine flowLine) {
        if (flowLines.containsKey(type)) {
            if (flowLine != null)
                ((MyHashSet)flowLines.get(type)).add(flowLine);
        } else { // add new path type
            MyHashSet newSet = new MyHashSet();
            if (flowLine != null)
                newSet.add(flowLine);
            flowLines.put(type, newSet);
        }
    }

    public Object clone() {
        Flow cl = new Flow();
//        cl.stateVariables = (Object[])stateVariables.clone();
        cl.flowLines = new HashMap();
        Iterator iterator = flowLines.keySet().iterator();

        while (iterator.hasNext()) {
            Object currentKey = iterator.next();
            cl.addFlowLine((String)currentKey, null);
            Iterator currentFlowLines = ((MyHashSet)flowLines.get(currentKey)).iterator();
            while (currentFlowLines.hasNext())
                cl.addFlowLine((String)currentKey, ((FlowLine)currentFlowLines.next()).deepCopy());
        }

        return cl;
    }

    public FlowInterface manipulateFlowLine(String type, FlowLineManipulator manipulator) {
        MyHashSet newSet = new MyHashSet();
        Iterator iterator = ((HashSet)flowLines.get(type)).iterator();
        this.resetFlowLines(type);
        while (iterator.hasNext()) {
            FlowLine[] newLines = manipulator.manipulate((FlowLine)iterator.next());
            if (newLines != null) {
                for (int i = 0; i < newLines.length; i++)
                    newSet.add(newLines[i]);
            }
        }
        flowLines.put(type,newSet);
        return this;
    }

    public void resetFlowLines(String type) {
        flowLines.put(type, new MyHashSet());
    }

    public boolean isAlwaysTrue(String type, BooleanFlowLineMethod method) {
        Iterator iterator = ((MyHashSet)flowLines.get(type)).iterator();
        while (iterator.hasNext()) {
            if (!method.isTrue((FlowLine)iterator.next()))
                return false;
        }
        return true;
    }

    public Object extractInfo(String type, FlowMethod method) {
        return method.extractInfo(/*stateVariables,*/ (MyHashSet)flowLines.get(type));
    }

    public static class MyHashSet extends HashSet {

        public boolean addAll(Collection c) {
            Iterator elements = c.iterator();
            while (elements.hasNext())
                add(elements.next());
            return false;
        }

        public boolean add(Object o) {
            if (!alreadyThere(o))
                return super.add(o);
            return false;
        }

        private boolean alreadyThere(Object o) {
            Iterator elements = this.iterator();
            while (elements.hasNext()) {
                Object o2 = elements.next();
                if (o2.equals(o))
                    return true;
            }
            return false;
        }

    }

}