/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/java/JavaFileCollector.java#3 $
 */

package com.sap.tc.jtools.jlint.java;

import java.io.File;
import java.util.Vector;

import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;

/**
 * This class can be used to collect the set of Java source files in a given directory
 * into a test object of type JavaFileArrayTestObject
 * 
 */

public class JavaFileCollector {

	private static final String JAVA_EXTENSION_JAVA = ".java"; //$NON-NLS-1$

	/**
	 * returns a test object containing all .java-files contained in the given directory
	 * 
	 * @param directory directory name (full path)
	 * @return test object
	 * @throws InvalidTestObjectSpecification
	 * 
	 */
	public TestObject getFiles(String directory)
		throws InvalidTestObjectSpecification {
		File f = new File(directory);
		Vector list = new Vector();
		doFile(f, list, directory);
		return new JavaFileArrayTestObject(
			directory,
			(String[]) list.toArray(new String[list.size()]));
	}

	private void doFile(File f, Vector list, String directory) {
		if (f.isDirectory()) {
			String files[] = f.list();
			for (int i = 0; i < files.length; i++) {
				doFile(new File(f, files[i]), list, directory);
			}
		} // otherwise, if this is a java file, parse it!
		else {
			if ((f.getName().length() > JAVA_EXTENSION_JAVA.length())
				&& f
					.getName()
					.substring(
						f.getName().length() - JAVA_EXTENSION_JAVA.length())
					.equals(JAVA_EXTENSION_JAVA)) {
					list.add(
						f.getAbsolutePath().substring(directory.length() + 1));
			}
		}
	}
}