
package com.sapmarkets.technology.fileloader;

import java.util.Enumeration;
import java.io.InputStream;

public class SubFileLoader extends FileLoader {

   String     prefix;
   FileLoader loader;

   public SubFileLoader(FileLoader loader, String prefix)
   {
     if (!prefix.endsWith("/")) prefix+="/";
     this.prefix=prefix;
     this.loader=loader;
   }

  public InputStream getInputStream(String name)
			throws ResourceNotFoundException
  { return loader.getInputStream(prefix+name);
  }

  public boolean isDirectory(String name)
			throws ResourceNotFoundException
  { return loader.isDirectory(prefix+name);
  }

  public long lastModified(String name)
			throws ResourceNotFoundException
  { return loader.lastModified(prefix+name);
  }

  public boolean hasFile(String name)
  {
    return loader.hasFile(prefix+name);
  }

  public String getFilePath()
  { return "prefix "+prefix+": "+loader.getFilePath();
  }

  public Enumeration entries()
  { return new SourceEnumeration(super.entries());
  }

  class SourceEnumeration implements Enumeration {
    Enumeration files;
    Object next;

    SourceEnumeration(Enumeration f)
    { files=f;
      next();
    }
    
    private void next()
    {
      next=null;
      while (files.hasMoreElements()) {
	next=files.nextElement();
	if (((String)next).startsWith(prefix)) break;
	next=null;
      }
    }

    public boolean hasMoreElements()
    { return next!=null;
    }

    public Object nextElement()
    { Object o=next;
      next();
      return o;
    }
  }
}
