/*
 * SAPMarkets Copyright (c) 2001
 * All rights reserved
 *
 * @version $Id: //sapmarkets/BaseTech/630_VAL_REL/src/_fileloader/java/com/sapmarkets/technology/fileloader/IFileSource.java#1 $
 */

package com.sapmarkets.technology.fileloader;

import java.io.InputStream;
import java.util.Enumeration;

/**
 * Interface describing a file source.
 *
 * @created   24. July 2001
 */
public interface IFileSource
{
  /**
   * Get an input stream for a named file.
   *
   * @param name                        Name of file to be retrieved
   * @return                            Input stream for file to be retrieved
   * @exception ResourceNotFoundException 
   *			   Exception thrown when class to be retrieved not found
   */
  public InputStream getInputStream(String name)
      throws ResourceNotFoundException;

  /**
   * Check named file for directory type
   *
   * @param name                        Name of file to be retrieved
   * @return                            file to be retrieved is directory
   * @exception ResourceNotFoundException 
   *			   Exception thrown when class to be retrieved not found
   */
  public boolean isDirectory(String name)
			throws ResourceNotFoundException;

  /**
   * Get modification time for a named file.
   *
   * @param name                        Name of file to be retrieved
   * @return                            Modification time for file to be
   *                                    retrieved
   * @exception ResourceNotFoundException 
   *			   Exception thrown when class to be retrieved not found
   */
  public long lastModified(String name)
			throws ResourceNotFoundException;

  /**
   * Check for a named file.
   *
   * @param name                        Name of file to be retrieved
   * @return                            Modification time for file to be
   *                                    retrieved
   * @exception ResourceNotFoundException 
   *			   Exception thrown when class to be retrieved not found
   */
  public boolean hasFile(String name);

  /**
   * Get an enumeration of all entries in the file source.
   *
   * @param name                        Name of file to be retrieved
   * @return                            Enumeration of all source entries
   */
  public Enumeration entries();

  /**
   * Get file path this file source references.
   * Each entry including the last must be terminated
   * with a semicolon.
   *
   * @return   File path this file source references
   */
  public String getFilePath();
}
