/*
 * SAPMarkets Copyright (c) 2001
 * All rights reserved
 *
 * @version $Id: //sapmarkets/BaseTech/630_VAL_REL/src/_fileloader/java/com/sapmarkets/technology/fileloader/FileEnumeration.java#1 $
 */

package com.sapmarkets.technology.fileloader;


import java.io.*;
import java.util.*;

public class FileEnumeration implements Enumeration {
  File[]          files;
  int             index;
  int             pathLength;
  FileEnumeration sub=null;

  public FileEnumeration()
  { files=null;
    index=0;
    pathLength=0;
  }

  private FileEnumeration(File dir, int pathLength) throws IOException
  { this.files=dir.listFiles();
    this.index=0;
    this.pathLength=pathLength;
  }

  public FileEnumeration(File dir) throws IOException
  { files=dir.listFiles();
    index=0;
    pathLength=dir.getCanonicalPath().length();
  }

  public boolean hasMoreElements()
  {
    if (sub!=null) return true;
    if (files!=null && index<files.length) return true;
    return false;
  }

  public Object nextElement()
  { String path;

    if (sub!=null) {
      path=(String)sub.nextElement();
      if (!sub.hasMoreElements()) sub=null;
    }
    else {
      try {
	path=files[index].getCanonicalPath();
	//System.out.println("path("+pathLength+")="+path);
	if (files[index].isDirectory()) {
	  sub=new FileEnumeration(files[index],pathLength);
	  if (!sub.hasMoreElements()) sub=null;
	}
	path=path.substring(pathLength+1);
	//System.out.println("   ->"+path);
      }
      catch (IOException e) {
	path=files[index].getAbsolutePath();
      }
      index++;
    }
    return path;
  }
}
