/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository_pmr/src/packages/com/sap/tc/webdynpro/progmodel/repository/enum/WDOutboundPlugTypeEnumInfo.java#1 $
 */

package com.sap.tc.webdynpro.progmodel.repository.enum;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Enumeration for outbound plug types. 
 * @author SAP
 */
public class WDOutboundPlugTypeEnumInfo
{
  /**
   * Outbound plugs of type exit can be used to exit applications. 
   */
  public static final WDOutboundPlugTypeEnumInfo EXIT = new WDOutboundPlugTypeEnumInfo("exit");
  
  /**
   * Default type of outbound plugs.
   */
  public static final WDOutboundPlugTypeEnumInfo STANDARD = new WDOutboundPlugTypeEnumInfo("standard");

  private static Hashtable mMemberTable = init();
  private String mStringValue = null;

  // WDOutboundPlugTypeEnumInfo()
  private WDOutboundPlugTypeEnumInfo(String value)
  {
    mStringValue = value;
  }

  /**
   * Returns an enumeration of the legal values of this enerumeration type.
   * @return an enumeration of the legal values of this enerumeration type
   */
  public static Enumeration enumerate()
  {
    return mMemberTable.elements();
  }

  // init()
  private static Hashtable init()
  {
    Hashtable members = new Hashtable();
    members.put("exit", EXIT);
    members.put("standard", STANDARD);
    return members;
  }

  /**
   * Returns the string representation for this enumeration value.
   * @return the string representation for this enumeration value.
   */
  public String toString()
  {
    return mStringValue;
  }

  /**
   * Returns the enumeration value corresponding to the given string
   * representation.
   * @param string string representation of an enumeration value
   * @return the enumeration value corrseponding to the given string 
   * representation or null if it does not exist
   */
  public static WDOutboundPlugTypeEnumInfo valueOf(String string)
  {
    Object obj = null;
    if (string != null) obj = mMemberTable.get(string);
    return (WDOutboundPlugTypeEnumInfo) obj;
  }
}
